(*---------------------------------------------------------------------------

	Marian Wybraczyk (c) 2008

	naley zdefiniowa form na ktrej umieszczamy TScrollBox a na nim
	TImage (lub TPaintBox). Do MPrint przekazujemy Image->Canvas
	(lub odpowiednio PaintBox->Canvas)

	Rysowanie po Canvas metodami:

	Write(txt, f: TFont);
	Writeln(txt, f: TFont);
	Write(txt, f: TFont);
	Writeln(txt, f: TFont);
	Writeln(CRLF, f: TFont);	// tylko pusty wiersz
   //lub
   Writeln('',  f: TFont);  	// tylko pusty wiersz

	dla kazego wiersza zapamituj:
   tekst, akcje, font w:
	ListaWierszy
	ListaAkcji
	ListaCzcionek

------------------------------------------------------------------------------*)
unit UPlotno;

interface
Uses
   Forms, Dialogs, Windows, Classes, SysUtils, Graphics,
   UConsts;

Type

MPrint = class
private
	Canvas  		  : TCanvas;   																  // tylko wskanik na Canvas po ktrym trzeba rysowa
	x             : Integer;                                                     // pisz po ptnie uywajc TextOut(x, y, txt)
	y             : Integer;

	ListaWierszy  : TStringList;                                                 // wiersze do wypisania
	ListaAkcji    : TStringList;                                                 // Write, Writeln, CRLF
	ListaCzcionek : TList;                                                       // parametry czcionki dla kaego napisu - typu TFont

	margin_l      : Integer;
	margin_t      : Integer;

public
	procedure Writeln(txt : String; f : TFont);
	procedure Write(txt : String; f : TFont);
	procedure Add(const txt : String; newFonts : TFont; const sAkcja : String = WRITELN);

	procedure Show();                                                            // rysuj po Canvas na podstawie 3 List

	constructor Create(Canvas_    : TCanvas;                                     // po tym ptnie bdzie si odbywao rysowanie
  							 margin_l_  : Integer = 20;                                // domylny lewy margines
							 margin_t_  : Integer = 20);                               // domylny margines od gry


	destructor Destroy(); override;
end;


implementation
{------------------------------------------------------------------------------}
constructor MPrint.Create(Canvas_: TCanvas; margin_l_, margin_t_: Integer);
begin
	Canvas               := Canvas_;

	Canvas.Font.Name   := 'Times New Roman';
	Canvas.Font.Size   := 10;
	Canvas.Font.Color  := clBlack;

	Canvas.Brush.Style := bsClear;

	margin_l           := margin_l_;
	margin_t           := margin_t_;

	x                  := margin_l_;
	y                  := margin_l_;

	// tylko wskaniki
	ListaWierszy       := TStringList.Create();
	ListaAkcji         := TStringList.Create();
	ListaCzcionek      := TList.Create();
end;

procedure MPrint.Add(const txt: String; newFonts: TFont; const sAkcja: String);
var
   f : TFont;

begin
	ListaWierszy.Add(txt);

	f := TFont.Create();

	f.Style := newFonts.Style;
	f.Name  := newFonts.Name;
	f.Size  := newFonts.Size;
	f.Color := newFonts.Color;

	ListaCzcionek.Add(f);

	ListaAkcji.Add(sAkcja);
end;

destructor MPrint.Destroy();
var
	wsk : TFont;
   lp  : Integer;

begin
	if Assigned(ListaWierszy) then
	begin
		ListaWierszy.Clear();
		FreeAndNil(ListaWierszy);
	end;

	if Assigned(ListaAkcji) then
	begin
		ListaAkcji.Clear();
		FreeAndNil(ListaAkcji);
	end;

	if Assigned(ListaCzcionek) then
	begin
      for lp := 0 to ListaCzcionek.Count-1 do
      begin
			wsk := TFont(ListaCzcionek.Items[lp]);
		end;

		ListaCzcionek.Clear();
		FreeAndNil(ListaCzcionek);
	end;

	inherited;
end;

procedure MPrint.Show();

var
	txt      : String;
	lp       : Integer;
	sAkcja   : String;
	f        : TFont;

begin
	txt    := '';
	lp     := 0;
	sAkcja := '';
	f      := Nil;


   for lp := 0 to ListaWierszy.Count-1 do
	begin
		txt    := ListaWierszy.Strings[lp];
		sAkcja := ListaAkcji.Strings[lp];
		f      := TFont(ListaCzcionek.Items[lp]);

		if sAkcja = 'WRITE' then
		begin
			Write(txt, f);
		end;

		if sAkcja = 'WRITELN' then
		begin
			Writeln(txt, f);
		end;

		if sAkcja = CRLF then
		begin
			Writeln(CRLF, f);
		end;
	end;
end;

procedure MPrint.Writeln(txt: String; f: TFont);
var
	dody : Integer;

begin
	dody := 0;

	Canvas.Font.Name  := f.Name;
	Canvas.Font.Size  := f.Size;
	Canvas.Font.Color := f.Color;
	Canvas.Font.Style := f.Style;

   if Trim(txt) = '' then
   begin
		txt := CRLF;
   end;

	if txt <> CRLF then
	begin
		Canvas.TextOut(x, y, txt);
	end
	else begin
		// bez pisania - tylko powrt na pocztek wiersza
		// x := margin_l;
	end;
	
	dody := Canvas.TextHeight(txt);
	y    := y + dody;
   // powrt na pocztek dla nastepnego wiersza
	x := margin_l;   
end;

procedure MPrint.Write(txt: String; f: TFont);
var
	dodx : Integer;

begin
	dodx := 0;

	Canvas.Font.Name  := f.Name;
	Canvas.Font.Size  := f.Size;
	Canvas.Font.Color := f.Color;
	Canvas.Font.Style := f.Style;

   if Trim(txt) = '' then
   begin
		txt := CRLF;
   end;

	if txt <> CRLF then
	begin
		Canvas.TextOut(x, y, txt);
	end
	else begin
		// bez pisania - tylko powrt na pocztek wiersza
		// x := R.Left + margin_l;
		x := margin_l;
	end;

	dodx := Canvas.TextWidth(txt);
	x    := x + dodx + 5;
end;

end.

